/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.rental.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.erp.sales.rental.model.Dayprice;
import itx.erp.sales.rental.model.DaypriceEntry;
import itx.erp.sales.rental.service.RentalDaypriceService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;

public class RentalDaypriceController
extends BaseController {
    protected ErpConfig appConfig;
    protected RentalDaypriceService rentalDaypriceService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public RentalDaypriceService getRentalDaypriceService() {
        return this.rentalDaypriceService;
    }

    public void setRentalDaypriceService(RentalDaypriceService rentalDaypriceService) {
        this.rentalDaypriceService = rentalDaypriceService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        QueryResult<Dayprice> qrs = this.rentalDaypriceService.searchDayprice(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("dayprices", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = req.getParamInt("daypriceId");
        Dayprice p = this.rentalDaypriceService.readDayprice(id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("dayprice", p);
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        Dayprice p = new Dayprice();
        KeyValueList kvl = req.getKvl().getObject("dayprice");
        p.setDaypriceId(kvl.getValueInt("daypriceId"));
        p.setName(kvl.getValue("name"));
        List<KeyValueList> kvlDayentries = kvl.getList("entries");
        for (KeyValueList kvle : kvlDayentries) {
            DaypriceEntry e = new DaypriceEntry();
            e.setDescription(kvle.getValue("description"));
            e.setPrice(kvle.getDoubleCurrency("price"));
            e.setPriceMethod(kvle.getValue("priceMethod"));
            e.setStartDate(kvle.getValueDate("startDate"));
            e.setEndDate(kvle.getValueDate("endDate"));
            e.setMinDuration(kvle.getValueInt("minDuration"));
            e.setMaxDuration(kvle.getValueInt("maxDuration"));
            e.setArrivalDays(kvle.getValue("arrivalDays"));
            e.setDepartureDays(kvle.getValue("departureDays"));
            p.getEntries().add(e);
        }
        this.rentalDaypriceService.save(p);
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("daypriceId", p.getDaypriceId());
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("daypriceId");
        this.rentalDaypriceService.deleteDayprice(id);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

